/*
 * Java
 *
 * Copyright 2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.wadapps.intern;

import ej.wadapps.admin.Application;

/**
 * 
 */
public interface TrustService {

	/**
	 * Returns <code>true</code> if the given application is a system application, <code>false</code> otherwise.
	 * 
	 * @param application
	 *            the application to test.
	 * @return <code>true</code> if the given application is a system application, <code>false</code> otherwise.
	 */
	public boolean isSystemApp(Application application);

	/**
	 * Returns <code>true</code> if the given application is a trusted application, <code>false</code> otherwise.
	 * 
	 * @param application
	 *            the application to test.
	 * @return <code>true</code> if the given application is a trusted application, <code>false</code> otherwise.
	 */
	public boolean isTrusted(Application application);

}
