/*
 * Java
 *
 * Copyright 2015-2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.hal.gpio;

/**
 * This class configures and drives digital or analog pins. A pin is identified
 * with its port and the pin number of its port. Each port has a unique ID which
 * is implementation specific. Pin numbers are a zero-based indexes.
 */
public class GPIO {

	/**
	 * Specify the pin mode.
	 *
	 * @see #setMode(int, int, Mode)
	 */
	public enum Mode {

		/**
		 * Digital input pin mode.
		 */
		DIGITAL_INPUT,

		/**
		 * Digital input with internal pull-up resistor pin mode.
		 */
		DIGITAL_INPUT_PULLUP,

		/**
		 * Digital output pin mode.
		 */
		DIGITAL_OUTPUT,

		/**
		 * Analog input pin mode.
		 */
		ANALOG_INPUT,

		/**
		 * Analog output pin mode.
		 */
		ANALOG_OUTPUT;
	}

	/**
	 * Configures the pin mode using the enumeration {@link Mode}.
	 *
	 * @param port
	 *            port identifier
	 * @param pin
	 *            pin number
	 * @param mode
	 *            pin mode
	 * @throws IllegalArgumentException
	 *             when the combination port / pin is unreachable
	 * @throws NullPointerException
	 *             when <code>mode</code> is null
	 */
	public static void setMode(int port, int pin, Mode mode) {
		throw new RuntimeException();
	}

	/**
	 * Gets the value of the digital pin.<br>
	 * The returned value is undefined when the pin is not configured or
	 * configured as analog pin.
	 *
	 * @param port
	 *            port identifier
	 * @param pin
	 *            pin number
	 *
	 * @return <code>true</code> when the GPIO digital value is currently
	 *         <i>high</i>.
	 * @throws IllegalArgumentException
	 *             when the combination port / pin is unreachable
	 */
	public static boolean getDigitalValue(int port, int pin) {
		throw new RuntimeException();
	}

	/**
	 * Sets a value on the digital pin.<br>
	 *
	 * @param port
	 *            port identifier
	 * @param pin
	 *            pin number
	 * @param value
	 *            digital pin value: <code>true</code> for <i>high</i>,
	 *            <code>false</code> for <i>low</i>.
	 * @throws IllegalArgumentException
	 *             when the combination port / pin is unreachable
	 */
	public static void setDigitalValue(int port, int pin, boolean value) {
		throw new RuntimeException();
	}

	/**
	 * Gets the value of the analog pin (a value between <code>0</code> and the
	 * targeted hardware ADC maximum value).<br>
	 * The returned value is undefined when the pin is not configured or
	 * configured as digital pin.
	 *
	 * @param port
	 *            port identifier
	 * @param pin
	 *            pin number
	 *
	 * @return analog pin value.
	 * @throws IllegalArgumentException
	 *             when the combination port / pin is unreachable
	 */
	public static int getAnalogValue(int port, int pin) {
		throw new RuntimeException();
	}

	/**
	 * Sets a value on the analog pin. The value is a percentage which defines
	 * the duty cycle a DAC or a PWM has to produce.
	 *
	 * @param port
	 *            port identifier
	 * @param pin
	 *            pin number
	 * @param percentage
	 *            percentage of analog pin value.
	 * @throws IllegalArgumentException
	 *             when the combination port / pin is unreachable or when the
	 *             percentage is invalid
	 */
	public static void setAnalogValue(int port, int pin, int percentage) {
		throw new RuntimeException();
	}

}
